****


## OCC Access Violation handling

 
If an access violation occurs, programs generated by OCC will show a register dump.

In addition, during default SIGSEGV processing the program will attempt to load a debug helper dll, in order to show a stack trace.

The stack trace will either not be shown or be meaningless with 'release' builds, because normally for a release EBP is used as a scratch register rather than as a link register.   But if certain compiler switches are used that enable EBP to be used as a link register, the stack trace will be meaningful.

The first interesting switch is **+v (or -g)**.   This switch enables debug information.   When this switch is set EBP will also be set up as a link register.   Under these circumstances the program should be able to show a stack trace, complete with symbol information consisting of offsets into the functions referenced on the stack.

The next interesting switch is **/C-E**.   This switch enables using EBP as a link register, but does not otherwise affect the compile.   in this case a stack trace is shown, although without symbol information.

The latter so switch is just a little confusing because with **/C-E** inlining of functions is still enabled.   To get a clearer view it might be useful to use **/C-i** in conjunction with **/C-E**.   That will expand the call stack properly.  Do note though that doing this does not generate the same code as useing **+v** as it does not turn off optimizations.